package Requirements;

import java.awt.event.ActionEvent;


public class TrafficLightCluster implements java.awt.event.ActionListener
{ 
    private Light[] group1;
    private Light[] group2;
    private LightTimer schedule;
    private boolean loggedIn;
    // Hard-coded light change times
    int NORMAL_TIME_DELAY = 8000;
    int CHANGE_TIME_DELAY = 3000;
    int BLINK_TIME_DELAY = 500;

    
    /*
     * Constructor
    */
    public TrafficLightCluster()
    {
	loggedIn = false;
	group1 = new Light[2];
	group2 = new Light[2];
    }

    /*
     * Attempt to log the user in
    */
    public boolean Login(String name, String pass)
    {
	// We'll hard-code out account info, but we'd really want to call a database
	String Password = "pass";
	String Username = "name";
    
	if (name.equals(Username) && pass.equals(Password))
	{
	    loggedIn = true;
	    return true;
	}
	return false;
    }
    
    /*
     * Log the user out
    */
    public void Logout()
    {
	loggedIn = false;
    }
    
    /*
     * Create a timer, and add it to our timer array
    */
    public void CreateTimer(ScheduleType group1Type, ScheduleType group2Type)
    throws Exception
    {
	if (group1Type == null || group2Type == null)
	    throw new Exception("Input parameters can't be null");
	
	if (loggedIn)
	{
	    if (schedule != null) 
		schedule.stop();
	    schedule = new LightTimer(0,group1Type,group2Type,this);
	}
    }
    
    /*
     * Start the light schedule
    */
    public void EnableLights()
    {
	if (loggedIn && schedule != null)
	{
	    schedule.setDelay(0);
	    schedule.start();
	}
    }
    
    /*
     * Stop the current light schedule
    */
    public void DisableLights()
    {
	if (loggedIn && schedule != null)
	{
	    schedule.setDelay(0);
	    schedule.stop();
	}
    }

    /*
     * Set the north/south lights
    */
    public void SetGroup1(Light l1, Light l2) throws Exception
    {
	if (l1 == null || l2 == null) throw new Exception("Can't pass null values");
	group1[0] = l1;
	group1[1] = l2;
    }

    /*
     * Set the east/west lights
    */
    public void SetGroup2(Light l1, Light l2) throws Exception
    {
	if (l1 == null || l2 == null) throw new Exception("Can't pass null values");
	group2[0] = l1;
	group2[1] = l2;
    }
    
    /*
     * Change the lights when a LightTimer fires an event 
    */
    public void actionPerformed(ActionEvent actionEvent)
    {
	LightTimer lt = (LightTimer)actionEvent.getSource();
	
	// n/s and e/w are both in normal mode
	if (schedule.GetGroup1Type() == ScheduleType.NORMAL && 
	    schedule.GetGroup2Type() == ScheduleType.NORMAL)
	{
	    // group 1 to green, group 2 to red
	    if (group1[0].GetColor() == Color.GREEN && group2[0].GetColor() == Color.RED)
	    {
		lt.setDelay(CHANGE_TIME_DELAY);
		
		group1[0].SetColor(Color.YELLOW);group1[1].SetColor(Color.YELLOW);
		group2[0].SetColor(Color.RED);group2[1].SetColor(Color.RED);
	    }
	    // group 1 to yellow, group 2 stays red
	    else if (group1[0].GetColor() == Color.YELLOW && group2[0].GetColor() == Color.RED)
	    {
		lt.setDelay(NORMAL_TIME_DELAY);
		
		group1[0].SetColor(Color.RED);group1[1].SetColor(Color.RED);
		group2[0].SetColor(Color.GREEN);group2[1].SetColor(Color.GREEN);
	    }
	    // group 2 to green, group 1 to red
	    else if (group2[0].GetColor() == Color.GREEN && group1[0].GetColor() == Color.RED)
	    {
		lt.setDelay(CHANGE_TIME_DELAY);
		
		group2[0].SetColor(Color.YELLOW);group2[1].SetColor(Color.YELLOW);
		group1[0].SetColor(Color.RED);group1[1].SetColor(Color.RED);
	    }
	    // group 2 to yellow, group 1 stays red
	    else
	    {
		lt.setDelay(NORMAL_TIME_DELAY);
		
		group2[0].SetColor(Color.RED);group2[1].SetColor(Color.RED);
		group1[0].SetColor(Color.GREEN);group1[1].SetColor(Color.GREEN);
	    }
	}
	
	// If they're blink, we'll alternate the color for display purposes
	else
	{
	    lt.setDelay(BLINK_TIME_DELAY);
	    
	    // north/south lights are blink red
	    if (schedule.GetGroup1Type() == ScheduleType.BLINKRED)
	    {
		if (group1[0].GetColor() == Color.BLINK)
		{
		    group1[0].SetColor(Color.BLINKRED);
		    group1[1].SetColor(Color.BLINKRED);
		}
		else
		{
		    group1[0].SetColor(Color.BLINK);
		    group1[1].SetColor(Color.BLINK);
		}
	    }
	    
	    // north/south lights are blink yellow
	    else if (schedule.GetGroup1Type() == ScheduleType.BLINKYELLOW)
	    {
		if (group1[0].GetColor() == Color.BLINK)
		{
		    group1[0].SetColor(Color.BLINKYELLOW);
		    group1[1].SetColor(Color.BLINKYELLOW);
		}
		else
		{
		    group1[0].SetColor(Color.BLINK);
		    group1[1].SetColor(Color.BLINK);
		}
	    }
	    
	    // west/east lights are blink red
	    if (schedule.GetGroup2Type() == ScheduleType.BLINKRED)
	    {
		if (group2[0].GetColor() == Color.BLINK)
		{
		    group2[0].SetColor(Color.BLINKRED);
		    group2[1].SetColor(Color.BLINKRED);
		}
		else
		{
		    group2[0].SetColor(Color.BLINK);
		    group2[1].SetColor(Color.BLINK);
		}
	    }
	    
	    // west/east lights are blink yellow
	    else if (schedule.GetGroup2Type() == ScheduleType.BLINKYELLOW)
	    {
		if (group2[0].GetColor() == Color.BLINK)
		{
		    group2[0].SetColor(Color.BLINKYELLOW);
		    group2[1].SetColor(Color.BLINKYELLOW);
		}
		else
		{
		    group2[0].SetColor(Color.BLINK);
		    group2[1].SetColor(Color.BLINK);
		}
	    }
	}
    }

}